/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WorldDataCompilerAndOps<Format>
extends WorldGenSettingsExport<Format>
implements IDataProvider {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    private final Function<Format, String> fileContentWriter;
    protected final DynamicRegistries field_240895_b_;
    private DirectoryCache directoryCache;
    private final HashSet<Object> objectsSerializationCache = new HashSet();

    public WorldDataCompilerAndOps(DataGenerator generator, DynamicOps<Format> ops, Function<Format, String> fileContentWriter, DynamicRegistries dynamicRegistries) {
        super(ops, dynamicRegistries);
        this.generator = generator;
        this.fileContentWriter = fileContentWriter;
        this.field_240895_b_ = dynamicRegistries;
    }

    protected <Resource> Resource getOrCreateInRegistry(Registry<Resource> registry, RegistryKey<Resource> registryKey, Supplier<Resource> resourceCreator) {
        Object resourceSaved = WorldDataCompilerAndOps.getFromVanillaRegistryIllegally(registry, registryKey);
        if (resourceSaved == null) {
            resourceSaved = Registry.func_218322_a(registry, (ResourceLocation)registryKey.func_240901_a_(), resourceCreator.get());
        }
        return resourceSaved;
    }

    public final void func_200398_a(DirectoryCache directoryCache) {
        this.directoryCache = directoryCache;
        this.generate(directoryCache);
    }

    public abstract void generate(DirectoryCache var1);

    public <Resource> void serialize(RegistryKey<? extends Registry<Resource>> resourceType, ResourceLocation resourceLocation, Resource resource, Encoder<Resource> encoder) {
        if (this.objectsSerializationCache.contains(resource)) {
            LOGGER.debug("Avoiding duplicate serialization with " + resourceLocation);
            return;
        }
        this.objectsSerializationCache.add(resource);
        Optional output = ((DataResult)this.withEncoder(encoder).apply(resource)).setLifecycle(Lifecycle.experimental()).resultOrPartial(error -> LOGGER.error("Object [" + resourceType.getRegistryName() + "] " + resourceLocation + " not serialized within recursive serialization: " + error));
        if (output.isPresent()) {
            try {
                this.save(this.directoryCache, output.get(), WorldDataCompilerAndOps.makePath(this.generator.func_200391_b(), resourceType, resourceLocation));
            }
            catch (IOException e) {
                LOGGER.error("Could not save resource `" + resourceLocation + "` (Resource Type `" + resourceType.func_240901_a_() + "`)", (Throwable)e);
            }
        }
    }

    private static Path makePath(Path path, RegistryKey<?> key, ResourceLocation resc) {
        return path.resolve("data").resolve(resc.func_110624_b()).resolve(key.func_240901_a_().func_110623_a()).resolve(resc.func_110623_a() + ".json");
    }

    private void save(DirectoryCache cache, Format dynamic, Path pathIn) throws IOException {
        String s = this.fileContentWriter.apply(dynamic);
        String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
        if (!Objects.equals(cache.func_208323_a(pathIn), s1) || !Files.exists(pathIn, new LinkOption[0])) {
            Files.createDirectories(pathIn.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pathIn, new OpenOption[0]);){
                bufferedwriter.write(s);
            }
        }
        cache.func_208316_a(pathIn, s1);
    }

    @Nullable
    protected static <T> T getFromVanillaRegistryIllegally(Registry registry, RegistryKey<T> key) {
        return (T)registry.func_230516_a_(key);
    }

    private static <Resource> Optional<ResourceLocation> getFromForgeRegistryIllegally(RegistryKey<? extends Registry<Resource>> registryKey, Resource resource) {
        if (resource instanceof IForgeRegistryEntry) {
            IForgeRegistryEntry entry = (IForgeRegistryEntry)resource;
            ResourceLocation location = entry.getRegistryName();
            if (location != null) {
                return Optional.of(location);
            }
            ForgeRegistry forgeRegistry = RegistryManager.ACTIVE.getRegistry(registryKey.func_240901_a_());
            return Optional.ofNullable(forgeRegistry.getKey((IForgeRegistryEntry)resource));
        }
        return Optional.empty();
    }

    private <Resource> Optional<ResourceLocation> rummageForResourceLocation(Resource resource, RegistryKey<? extends Registry<Resource>> registryKey) {
        Registry<Resource> registry;
        Optional<ResourceLocation> instanceKey = Optional.empty();
        if (resource instanceof IForgeRegistryEntry) {
            instanceKey = Optional.ofNullable(((IForgeRegistryEntry)resource).getRegistryName());
        }
        if (!instanceKey.isPresent()) {
            try {
                MutableRegistry dynRegistry = this.field_240895_b_.func_243612_b(registryKey);
                instanceKey = dynRegistry != null ? dynRegistry.func_230519_c_(resource).map(RegistryKey::func_240901_a_) : Optional.empty();
            }
            catch (Throwable dynRegistry) {
                // empty catch block
            }
        }
        if (!instanceKey.isPresent() && (registry = WorldDataCompilerAndOps.getFromVanillaRegistryIllegally(WorldGenRegistries.field_243650_b, registryKey)) != null) {
            instanceKey = registry.func_230519_c_(resource).map(RegistryKey::func_240901_a_);
        }
        if (!instanceKey.isPresent() && (registry = WorldDataCompilerAndOps.getFromVanillaRegistryIllegally(Registry.field_212617_f, registryKey)) != null) {
            instanceKey = registry.func_230519_c_(resource).map(RegistryKey::func_240901_a_);
        }
        if (!instanceKey.isPresent()) {
            instanceKey = WorldDataCompilerAndOps.getFromForgeRegistryIllegally(registryKey, resource);
        }
        return instanceKey;
    }

    protected <Resource> DataResult<Format> func_241811_a_(Resource resource, Format dynamic, RegistryKey<? extends Registry<Resource>> registryKey, Codec<Resource> codec) {
        Optional<ResourceLocation> instanceKey = this.rummageForResourceLocation(resource, registryKey);
        if (instanceKey.isPresent()) {
            if ("twilightforest".equals(instanceKey.get().func_110624_b())) {
                this.serialize(registryKey, instanceKey.get(), resource, (Encoder<Resource>)codec);
            }
            return ResourceLocation.field_240908_a_.encode((Object)instanceKey.get(), this.field_240857_a_, dynamic);
        }
        return codec.encode(resource, (DynamicOps)this, dynamic);
    }

    public String func_200397_b() {
        return "Twilight World";
    }

    protected static Optional<DimensionSettings> makeDimensionSettings(DimensionStructuresSettings structures, NoiseSettings noise, BlockState defaultBlock, BlockState defaultFluid, int bedrockRoofPosition, int bedrockFloorPosition, int seaLevel, boolean disableMobGeneration) {
        try {
            Constructor ctor = DimensionSettings.class.getDeclaredConstructor(DimensionStructuresSettings.class, NoiseSettings.class, BlockState.class, BlockState.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            ctor.setAccessible(true);
            return Optional.of(ctor.newInstance(structures, noise, defaultBlock, defaultFluid, bedrockRoofPosition, bedrockFloorPosition, seaLevel, disableMobGeneration));
        }
        catch (Exception e) {
            LOGGER.error("Error constructing `DimensionSettings`!", (Throwable)e);
            return Optional.empty();
        }
    }

    protected static Optional<DimensionType> makeDimensionType(OptionalLong fixedTime, boolean hasSkyLight, boolean hasCeiling, boolean ultrawarm, boolean natural, double coordinateScale, boolean hasDragonFight, boolean piglinSafe, boolean bedWorks, boolean respawnAnchorWorks, boolean hasRaids, int logicalHeight, IBiomeMagnifier magnifier, ResourceLocation infiniburn, ResourceLocation effects, float ambientLight) {
        try {
            Constructor ctor = DimensionType.class.getDeclaredConstructor(OptionalLong.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, IBiomeMagnifier.class, ResourceLocation.class, ResourceLocation.class, Float.TYPE);
            ctor.setAccessible(true);
            return Optional.of(ctor.newInstance(fixedTime, hasSkyLight, hasCeiling, ultrawarm, natural, coordinateScale, hasDragonFight, piglinSafe, bedWorks, respawnAnchorWorks, hasRaids, logicalHeight, magnifier, infiniburn, effects, Float.valueOf(ambientLight)));
        }
        catch (Exception e) {
            LOGGER.error("Error constructing `DimensionType`!", (Throwable)e);
            return Optional.empty();
        }
    }
}

